<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $categoryId = $_POST['categoryid'] ?? null;
    $categoryKey = "category_" . (string)$categoryId; // Format the session key

    // Check if the session key exists
    if ($categoryId && isset($_SESSION[$categoryKey])) { 
        // Unset the session data for this category
        unset($_SESSION[$categoryKey]);
        echo json_encode(['status' => 'success', 'message' => "Session reset for category $categoryKey"]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Category ID not found in session']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}
